Name	"ClickOnGold"

Caption "ClickOnGold Software"
OutFile ClickOnGoldSetup.exe


DirText "Please select a location to install ClickOnGold (or use the default):"
SetOverwrite on

InstallDir $PROGRAMFILES\ClickOnGold


Section "ClickOnGold core files"

	SetShellVarContext All
	
	SetOutPath $INSTDIR
	File ClickOnGold.exe
	File Help.txt
	File sample.bmp
	File sample.cog


	SetoutPath "$SMPROGRAMS\ClickOnGold\"
	CreateShortCut "$SMPROGRAMS\ClickOnGold\ClickOnGold.lnk" "$INSTDIR\ClickOnGold.exe"
	CreateShortcut "$SMPROGRAMS\ClickOnGold\uninstall.lnk" "$INSTDIR\uninstall.exe"


	SetoutPath $DESKTOP
	CreateShortCut "$DESKTOP\ClickOnGold.lnk" "$INSTDIR\ClickOnGold.exe"


	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ClickOnGold" "DisplayName" "ClickOnGold(remove only)"
    	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ClickOnGold" "UninstallString" '"$INSTDIR\uninstall.exe"'


	WriteUninstaller "uninstall.exe"

SectionEnd

UninstallText "This will uninstall ClickOnGold from your computer:"

Section Uninstall
	SetShellVarContext All
	

	Delete $SMPROGRAMS\ClickOnGold\*.*
	RMDir  $SMPROGRAMS\ClickOnGold

	Delete $INSTDIR\*.*
	Delete $INSTDIR\uninstall.exe
	RMDir  $INSTDIR

	Delete $DESKTOP\ClickOnGold.lnk

	DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ClickOnGold"
SectionEnd
