/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;

public class Translator
implements ExtendedPlugInFilter,
DialogListener {
    private int flags = 32799;
    private static int xOffset = 15;
    private static int yOffset = 15;
    private ImagePlus imp;
    GenericDialog gd;
    PlugInFilterRunner pfr;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return this.flags;
    }

    public void run(ImageProcessor ip) {
        if (this.imp.getRoi() != null && this.imp.getRoi().isArea()) {
            ip.translate(xOffset, yOffset, false);
        } else {
            ip.translate(xOffset, yOffset, true);
        }
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        this.pfr = pfr;
        this.gd = new GenericDialog("Translate");
        this.gd.addNumericField("X Offset (pixels): ", xOffset, 0);
        this.gd.addNumericField("Y Offset (pixels): ", yOffset, 0);
        this.gd.addPreviewCheckbox(pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return 4096;
        }
        return IJ.setupDialog(imp, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        xOffset = (int)gd.getNextNumber();
        yOffset = (int)gd.getNextNumber();
        if (gd.invalidNumber()) {
            if (gd.wasOKed()) {
                IJ.error("Offset is invalid.");
            }
            return false;
        }
        return true;
    }

    public void setNPasses(int nPasses) {
    }
}

