/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.plugin.frame.Channels;
import ij.plugin.frame.ContrastAdjuster;
import ij.process.ByteBlitter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatBlitter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.ShortBlitter;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class CompositeImage
extends ImagePlus {
    public static final int COMPOSITE = 1;
    public static final int COLOR = 2;
    public static final int GRAYSCALE = 3;
    public static final int TRANSPARENT = 4;
    public static final int MAX_CHANNELS = 7;
    int[] rgbPixels;
    boolean newPixels;
    MemoryImageSource imageSource;
    Image awtImage;
    WritableRaster rgbRaster;
    SampleModel rgbSampleModel;
    BufferedImage rgbImage;
    ColorModel rgbCM;
    ImageProcessor[] cip;
    Color[] colors = new Color[]{Color.red, Color.green, Color.blue, Color.white, Color.cyan, Color.magenta, Color.yellow};
    LUT[] lut;
    int currentChannel = -1;
    int previousChannel;
    int currentSlice = 1;
    int currentFrame = 1;
    static int count;
    boolean singleChannel;
    boolean[] active = new boolean[7];
    int mode = 2;
    int bitDepth;
    boolean customLut;
    double[] displayRanges;
    byte[][] channelLuts;
    boolean customLuts;
    boolean syncChannels;

    public CompositeImage(ImagePlus imp) {
        this(imp, 2);
    }

    public CompositeImage(ImagePlus imp, int mode) {
        ImageStack stack2;
        boolean isRGB;
        if (mode < 1 || mode > 3) {
            mode = 2;
        }
        this.mode = mode;
        int channels = imp.getNChannels();
        this.bitDepth = this.getBitDepth();
        if (IJ.debugMode) {
            IJ.log("CompositeImage: " + imp + " " + mode + " " + channels);
        }
        boolean bl = isRGB = imp.getBitDepth() == 24;
        if (isRGB) {
            if (imp.getImageStackSize() > 1) {
                throw new IllegalArgumentException("RGB stacks not supported");
            }
            stack2 = this.getRGBStack(imp);
        } else {
            stack2 = imp.getImageStack();
        }
        int stackSize = stack2.getSize();
        if (channels == 1 && isRGB) {
            channels = 3;
        }
        if (channels == 1 && stackSize <= 7) {
            channels = stackSize;
        }
        if (channels < 2 || stackSize % channels != 0) {
            throw new IllegalArgumentException("channels<2 or stacksize not multiple of channels");
        }
        if (mode == 1 && channels > 7) {
            this.mode = 2;
        }
        this.compositeImage = true;
        int z = imp.getNSlices();
        int t = imp.getNFrames();
        if (channels == stackSize || channels * z * t != stackSize) {
            this.setDimensions(channels, stackSize / channels, 1);
        } else {
            this.setDimensions(channels, z, t);
        }
        this.setStack(imp.getTitle(), stack2);
        this.setCalibration(imp.getCalibration());
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi != null) {
            this.displayRanges = fi.displayRanges;
            this.channelLuts = fi.channelLuts;
        }
        this.setFileInfo(fi);
        Object info = imp.getProperty("Info");
        if (info != null) {
            this.setProperty("Info", imp.getProperty("Info"));
        }
        if (mode == 1) {
            for (int i = 0; i < 7; ++i) {
                this.active[i] = true;
            }
        } else {
            this.active[0] = true;
        }
        if (channels != stackSize) {
            this.setOpenAsHyperStack(true);
        }
    }

    public Image getImage() {
        if (this.img == null) {
            this.updateImage();
        }
        return this.img;
    }

    public void updateChannelAndDraw() {
        if (!this.customLut) {
            this.singleChannel = true;
        }
        this.updateAndDraw();
    }

    public void updateAllChannelsAndDraw() {
        if (this.mode != 1) {
            this.updateChannelAndDraw();
        } else {
            this.syncChannels = true;
            this.singleChannel = false;
            this.updateAndDraw();
        }
    }

    public ImageProcessor getChannelProcessor() {
        if (this.cip != null && this.currentChannel != -1) {
            return this.cip[this.currentChannel];
        }
        return this.getProcessor();
    }

    void setup(int channels, ImageStack stack2) {
        this.setupLuts(channels);
        if (this.mode == 1) {
            this.cip = new ImageProcessor[channels];
            for (int i = 0; i < channels; ++i) {
                this.cip[i] = stack2.getProcessor(i + 1);
                this.cip[i].setColorModel(this.lut[i]);
                this.cip[i].setMinAndMax(this.lut[i].min, this.lut[i].max);
            }
            this.currentFrame = 1;
            this.currentSlice = 1;
        }
    }

    void setupLuts(int channels) {
        if (this.lut == null || this.lut.length < channels) {
            if (this.displayRanges != null && channels != this.displayRanges.length / 2) {
                this.displayRanges = null;
            }
            if (this.displayRanges == null && this.ip.getMin() == 0.0 && this.ip.getMax() == 0.0) {
                this.ip.resetMinAndMax();
            }
            this.lut = new LUT[channels];
            LUT lut2 = channels > 7 ? this.createLutFromColor(Color.white) : null;
            for (int i = 0; i < channels; ++i) {
                if (this.channelLuts != null && i < this.channelLuts.length) {
                    this.lut[i] = this.createLutFromBytes(this.channelLuts[i]);
                    this.customLuts = true;
                } else {
                    this.lut[i] = i < 7 ? this.createLutFromColor(this.colors[i]) : (LUT)lut2.clone();
                }
                if (this.displayRanges != null) {
                    this.lut[i].min = this.displayRanges[i * 2];
                    this.lut[i].max = this.displayRanges[i * 2 + 1];
                    continue;
                }
                this.lut[i].min = this.ip.getMin();
                this.lut[i].max = this.ip.getMax();
            }
            this.displayRanges = null;
        }
    }

    public void resetDisplayRanges() {
        int channels = this.getNChannels();
        ImageStack stack2 = this.getImageStack();
        if (this.lut == null || channels != this.lut.length || channels > stack2.getSize() || channels > 7) {
            return;
        }
        for (int i = 0; i < channels; ++i) {
            ImageProcessor ip2 = stack2.getProcessor(i + 1);
            ip2.resetMinAndMax();
            this.lut[i].min = ip2.getMin();
            this.lut[i].max = ip2.getMax();
        }
    }

    public void updateAndDraw() {
        this.updateImage();
        if (this.win != null) {
            this.notifyListeners(2);
        }
        this.draw();
    }

    public synchronized void updateImage() {
        int imageSize = this.width * this.height;
        int nChannels = this.getNChannels();
        int ch = this.getChannel();
        if (ch > nChannels) {
            ch = nChannels;
        }
        boolean newChannel = false;
        if (ch - 1 != this.currentChannel) {
            this.previousChannel = this.currentChannel;
            this.currentChannel = ch - 1;
            newChannel = true;
        }
        ImageProcessor ip = this.getProcessor();
        if (this.mode != 1) {
            if (newChannel) {
                this.setupLuts(nChannels);
                LUT cm = this.lut[this.currentChannel];
                if (this.mode == 2) {
                    ip.setColorModel(cm);
                }
                if (cm.min != 0.0 || cm.max != 0.0) {
                    ip.setMinAndMax(cm.min, cm.max);
                }
                if (!IJ.isMacro()) {
                    ContrastAdjuster.update();
                }
                Frame channels = Channels.getInstance();
                for (int i = 0; i < 7; ++i) {
                    this.active[i] = i == this.currentChannel;
                }
                if (channels != null) {
                    ((Channels)channels).update();
                }
            }
            this.img = ip.createImage();
            return;
        }
        if (nChannels == 1) {
            this.cip = null;
            this.rgbPixels = null;
            this.awtImage = null;
            if (ip != null) {
                this.img = ip.createImage();
            }
            return;
        }
        if (this.cip == null || this.cip[0].getWidth() != this.width || this.cip[0].getHeight() != this.height || this.getBitDepth() != this.bitDepth) {
            this.setup(nChannels, this.getImageStack());
            this.rgbPixels = null;
            this.rgbSampleModel = null;
            if (this.currentChannel >= nChannels) {
                this.setSlice(1);
                this.currentChannel = 0;
                newChannel = true;
            }
            this.bitDepth = this.getBitDepth();
        }
        if (newChannel) {
            this.getProcessor().setMinAndMax(this.cip[this.currentChannel].getMin(), this.cip[this.currentChannel].getMax());
            if (!IJ.isMacro()) {
                ContrastAdjuster.update();
            }
        }
        if (this.isHyperStack() && (this.getSlice() != this.currentSlice || this.getFrame() != this.currentFrame)) {
            this.currentSlice = this.getSlice();
            this.currentFrame = this.getFrame();
            int position = (this.currentFrame - 1) * nChannels * this.getNSlices() + (this.currentSlice - 1) * nChannels + 1;
            for (int i = 0; i < nChannels; ++i) {
                this.cip[i].setPixels(this.getImageStack().getProcessor(position + i).getPixels());
            }
        }
        if (this.rgbPixels == null) {
            this.rgbPixels = new int[imageSize];
            this.newPixels = true;
            this.imageSource = null;
            this.rgbRaster = null;
            this.rgbImage = null;
        }
        this.cip[this.currentChannel].setMinAndMax(ip.getMin(), ip.getMax());
        if (this.singleChannel && nChannels <= 3) {
            switch (this.currentChannel) {
                case 0: {
                    this.cip[0].updateComposite(this.rgbPixels, 1);
                    break;
                }
                case 1: {
                    this.cip[1].updateComposite(this.rgbPixels, 2);
                    break;
                }
                case 2: {
                    this.cip[2].updateComposite(this.rgbPixels, 3);
                }
            }
        } else {
            if (this.syncChannels) {
                ImageProcessor ip2 = this.getProcessor();
                double min = ip2.getMin();
                double max = ip2.getMax();
                for (int i = 0; i < nChannels; ++i) {
                    this.cip[i].setMinAndMax(min, max);
                    this.lut[i].min = min;
                    this.lut[i].max = max;
                }
                this.syncChannels = false;
            }
            if (this.active[0]) {
                this.cip[0].updateComposite(this.rgbPixels, 4);
            } else {
                for (int i = 1; i < imageSize; ++i) {
                    this.rgbPixels[i] = 0;
                }
            }
            for (int i = 1; i < nChannels; ++i) {
                if (!this.active[i]) continue;
                this.cip[i].updateComposite(this.rgbPixels, 5);
            }
        }
        if (IJ.isJava16()) {
            this.createBufferedImage();
        } else {
            this.createImage();
        }
        if (this.img == null && this.awtImage != null) {
            this.img = this.awtImage;
        }
        this.singleChannel = false;
    }

    void createImage() {
        if (this.imageSource == null) {
            this.rgbCM = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.imageSource = new MemoryImageSource(this.width, this.height, this.rgbCM, this.rgbPixels, 0, this.width);
            this.imageSource.setAnimated(true);
            this.imageSource.setFullBufferUpdates(true);
            this.awtImage = Toolkit.getDefaultToolkit().createImage(this.imageSource);
            this.newPixels = false;
        } else if (this.newPixels) {
            this.imageSource.newPixels(this.rgbPixels, this.rgbCM, 0, this.width);
            this.newPixels = false;
        } else {
            this.imageSource.newPixels();
        }
    }

    void createBufferedImage() {
        if (this.rgbSampleModel == null) {
            this.rgbSampleModel = this.getRGBSampleModel();
        }
        if (this.rgbRaster == null) {
            DataBufferInt dataBuffer = new DataBufferInt(this.rgbPixels, this.width * this.height, 0);
            this.rgbRaster = Raster.createWritableRaster(this.rgbSampleModel, dataBuffer, null);
        }
        if (this.rgbImage == null) {
            this.rgbImage = new BufferedImage(this.rgbCM, this.rgbRaster, false, null);
        }
        this.awtImage = this.rgbImage;
    }

    SampleModel getRGBSampleModel() {
        this.rgbCM = new DirectColorModel(24, 0xFF0000, 65280, 255);
        WritableRaster wr = this.rgbCM.createCompatibleWritableRaster(1, 1);
        SampleModel sampleModel = wr.getSampleModel();
        sampleModel = sampleModel.createCompatibleSampleModel(this.width, this.height);
        return sampleModel;
    }

    void createBlitterImage(int n) {
        ImageProcessor ip = this.cip[n - 1].duplicate();
        if (ip instanceof FloatProcessor) {
            FloatBlitter fb = new FloatBlitter((FloatProcessor)ip);
            for (int i = 1; i < n; ++i) {
                fb.copyBits(this.cip[i], 0, 0, 14);
            }
        } else if (ip instanceof ByteProcessor) {
            ByteBlitter bb = new ByteBlitter((ByteProcessor)ip);
            for (int i = 1; i < n; ++i) {
                bb.copyBits(this.cip[i], 0, 0, 10);
            }
        } else if (ip instanceof ShortProcessor) {
            ShortBlitter sb = new ShortBlitter((ShortProcessor)ip);
            for (int i = n - 2; i >= 0; --i) {
                sb.copyBits(this.cip[i], 0, 0, 10);
            }
        }
        this.img = ip.createImage();
        this.singleChannel = false;
    }

    ImageStack getRGBStack(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        int w = ip.getWidth();
        int h = ip.getHeight();
        int size = w * h;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ((ColorProcessor)ip).getRGB(r, g, b);
        ImageStack stack = new ImageStack(w, h);
        stack.addSlice("Red", r);
        stack.addSlice("Green", g);
        stack.addSlice("Blue", b);
        stack.setColorModel(ip.getDefaultColorModel());
        return stack;
    }

    public LUT createLutFromColor(Color color) {
        byte[] rLut = new byte[256];
        byte[] gLut = new byte[256];
        byte[] bLut = new byte[256];
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        double rIncr = (double)red / 255.0;
        double gIncr = (double)green / 255.0;
        double bIncr = (double)blue / 255.0;
        for (int i = 0; i < 256; ++i) {
            rLut[i] = (byte)((double)i * rIncr);
            gLut[i] = (byte)((double)i * gIncr);
            bLut[i] = (byte)((double)i * bIncr);
        }
        return new LUT(rLut, gLut, bLut);
    }

    LUT createLutFromBytes(byte[] bytes) {
        int i;
        if (bytes == null || bytes.length != 768) {
            return this.createLutFromColor(Color.white);
        }
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (i = 0; i < 256; ++i) {
            r[i] = bytes[i];
        }
        for (i = 0; i < 256; ++i) {
            g[i] = bytes[256 + i];
        }
        for (i = 0; i < 256; ++i) {
            b[i] = bytes[512 + i];
        }
        return new LUT(r, g, b);
    }

    public Color getChannelColor() {
        if (this.lut == null || this.mode == 3) {
            return Color.black;
        }
        LUT cm = this.lut[this.getChannelIndex()];
        if (cm == null) {
            return Color.black;
        }
        int index = cm.getMapSize() - 1;
        int r = cm.getRed(index);
        int g = cm.getGreen(index);
        int b = cm.getBlue(index);
        if (r < 100 || g < 100 || b < 100) {
            return new Color(r, g, b);
        }
        return Color.black;
    }

    public ImageProcessor getProcessor(int channel) {
        if (this.cip == null || channel > this.cip.length) {
            return null;
        }
        return this.cip[channel - 1];
    }

    public boolean[] getActiveChannels() {
        return this.active;
    }

    public void setMode(int mode) {
        Frame channels;
        int i;
        if (mode < 1 || mode > 3) {
            return;
        }
        if (mode == 1 && this.getNChannels() > 7) {
            mode = 2;
        }
        for (i = 0; i < 7; ++i) {
            this.active[i] = true;
        }
        if (this.mode != 1 && mode == 1) {
            this.img = null;
        }
        this.mode = mode;
        if (mode == 2 || mode == 3) {
            if (this.cip != null) {
                for (i = 0; i < this.cip.length; ++i) {
                    if (this.cip[i] != null) {
                        this.cip[i].setPixels(null);
                    }
                    this.cip[i] = null;
                }
            }
            this.cip = null;
            this.rgbPixels = null;
            this.awtImage = null;
            this.currentChannel = -1;
        }
        if (mode == 3 || mode == 4) {
            this.ip.setColorModel(this.ip.getDefaultColorModel());
        }
        if ((channels = Channels.getInstance()) != null) {
            ((Channels)channels).update();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public String getModeAsString() {
        switch (this.mode) {
            case 1: {
                return "composite";
            }
            case 2: {
                return "color";
            }
            case 3: {
                return "grayscale";
            }
        }
        return "";
    }

    public LUT getChannelLut(int channel) {
        int channels = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(channels);
        }
        if (channel < 1 || channel > this.lut.length) {
            throw new IllegalArgumentException("Channel out of range");
        }
        return this.lut[channel - 1];
    }

    public LUT getChannelLut() {
        int c = this.getChannelIndex();
        return this.lut[c];
    }

    public LUT[] getLuts() {
        int channels = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(channels);
        }
        LUT[] luts = new LUT[channels];
        for (int i = 0; i < channels; ++i) {
            luts[i] = (LUT)this.lut[i].clone();
        }
        return luts;
    }

    public void copyLuts(ImagePlus imp) {
        int channels = this.getNChannels();
        if (!imp.isComposite() || imp.getNChannels() != channels) {
            return;
        }
        CompositeImage ci = (CompositeImage)imp;
        LUT[] luts = ci.getLuts();
        if (luts != null && luts.length == channels) {
            this.lut = luts;
            this.cip = null;
        }
        int mode2 = ci.getMode();
        this.setMode(mode2);
        if (mode2 == 1) {
            boolean[] active2 = ci.getActiveChannels();
            for (int i = 0; i < 7; ++i) {
                this.active[i] = active2[i];
            }
        }
    }

    int getChannelIndex() {
        int channels = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(channels);
        }
        int index = this.getChannel() - 1;
        return index;
    }

    public void reset() {
        this.setup(this.getNChannels(), this.getImageStack());
    }

    public void setChannelLut(LUT table) {
        if (this.mode == 3) {
            this.getProcessor().setColorModel(table);
        } else {
            int c = this.getChannelIndex();
            double min = this.lut[c].min;
            double max = this.lut[c].max;
            this.lut[c] = table;
            this.lut[c].min = min;
            this.lut[c].max = max;
            if (this.mode == 1 && this.cip != null && c < this.cip.length) {
                this.cip[c].setColorModel(this.lut[c]);
                this.imageSource = null;
                this.newPixels = true;
                this.img = null;
            }
            this.currentChannel = -1;
            this.customLut = true;
            if (!IJ.isMacro()) {
                ContrastAdjuster.update();
            }
        }
        this.customLuts = true;
    }

    public void setChannelLut(LUT table, int channel) {
        int channels = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(channels);
        }
        if (channel < 1 || channel > this.lut.length) {
            throw new IllegalArgumentException("Channel out of range");
        }
        this.lut[channel - 1] = (LUT)table.clone();
        this.cip = null;
    }

    public void setChannelColorModel(IndexColorModel cm) {
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        cm.getReds(reds);
        cm.getGreens(greens);
        cm.getBlues(blues);
        this.setChannelLut(new LUT(8, cm.getMapSize(), reds, greens, blues));
    }

    public void setDisplayRange(double min, double max) {
        this.ip.setMinAndMax(min, max);
        int c = this.getChannelIndex();
        this.lut[c].min = min;
        this.lut[c].max = max;
    }

    public double getDisplayRangeMin() {
        return this.lut[this.getChannelIndex()].min;
    }

    public double getDisplayRangeMax() {
        return this.lut[this.getChannelIndex()].max;
    }

    public void resetDisplayRange() {
        this.ip.resetMinAndMax();
        int c = this.getChannelIndex();
        this.lut[c].min = this.ip.getMin();
        this.lut[c].max = this.ip.getMax();
    }

    public boolean hasCustomLuts() {
        return this.customLuts && this.mode != 3;
    }
}

