/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.plugin.PlugIn;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class CommandFinder
implements PlugIn,
TextListener,
ActionListener,
WindowListener,
KeyListener,
ItemListener {
    Dialog d;
    TextField prompt;
    List completions;
    Button runButton;
    Button closeButton;
    Checkbox fullInfoCheckbox;
    Checkbox closeCheckbox;
    Hashtable commandsHash;
    String[] commands;
    Hashtable listLabelToCommand;

    protected String makeListLabel(String command, CommandAction ca, boolean fullInfo) {
        if (fullInfo) {
            String result = command;
            if (ca.menuLocation != null) {
                result = result + " (in " + ca.menuLocation + ")";
            }
            if (ca.classCommand != null) {
                result = result + " [" + ca.classCommand + "]";
            }
            return result;
        }
        return command;
    }

    protected void populateList(String matchingSubstring) {
        boolean fullInfo = this.fullInfoCheckbox.getState();
        String substring = matchingSubstring.toLowerCase();
        this.completions.removeAll();
        for (int i = 0; i < this.commands.length; ++i) {
            String lowerCommandName;
            String commandName = this.commands[i];
            if (commandName.length() == 0 || (lowerCommandName = commandName.toLowerCase()).indexOf(substring) < 0) continue;
            CommandAction ca = (CommandAction)this.commandsHash.get(commandName);
            String listLabel = this.makeListLabel(commandName, ca, fullInfo);
            this.completions.add(listLabel);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.runButton) {
            String selected = this.completions.getSelectedItem();
            if (selected == null) {
                IJ.error("You must select a plugin to run");
                return;
            }
            this.runFromLabel(selected);
        } else if (source == this.closeButton) {
            this.d.dispose();
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        this.populateList(this.prompt.getText());
    }

    protected void runFromLabel(String listLabel) {
        String command = (String)this.listLabelToCommand.get(listLabel);
        CommandAction ca = (CommandAction)this.commandsHash.get(command);
        if (ca.classCommand != null) {
            IJ.showStatus("Running command " + ca.classCommand);
            IJ.doCommand(command);
        } else if (ca.menuItem != null) {
            IJ.showStatus("Clicking menu item " + ca.menuLocation + " > " + command);
            ActionEvent ae = new ActionEvent(ca.menuItem, 1001, command);
            ActionListener[] als = ca.menuItem.getActionListeners();
            for (int i = 0; i < als.length; ++i) {
                als[i].actionPerformed(ae);
            }
        } else {
            IJ.error("BUG: nothing to run found for '" + listLabel + "'");
            return;
        }
        if (this.closeCheckbox.getState()) {
            this.d.dispose();
        }
    }

    public void keyPressed(KeyEvent ke) {
        int key = ke.getKeyCode();
        int items = this.completions.getItemCount();
        Object source = ke.getSource();
        if (source == this.prompt) {
            if (key == 10) {
                if (1 == items) {
                    String selected = this.completions.getItem(0);
                    this.runFromLabel(selected);
                }
            } else if (key == 38) {
                this.completions.requestFocus();
                if (items > 0) {
                    this.completions.select(this.completions.getItemCount() - 1);
                }
            } else if (key == 40) {
                this.completions.requestFocus();
                if (items > 0) {
                    this.completions.select(0);
                }
            }
        } else if (source == this.completions) {
            String selected;
            if (key == 10 && (selected = this.completions.getSelectedItem()) != null) {
                this.runFromLabel(selected);
            }
        } else if (source == this.runButton) {
            String selected;
            if (key == 10 && (selected = this.completions.getSelectedItem()) != null) {
                this.runFromLabel(selected);
            }
        } else if (source == this.closeButton && key == 10) {
            this.d.dispose();
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void textValueChanged(TextEvent te) {
        this.populateList(this.prompt.getText());
    }

    public void parseMenu(String path, Menu menu) {
        int n = menu.getItemCount();
        for (int i = 0; i < n; ++i) {
            MenuItem m = menu.getItem(i);
            String label = m.getLabel();
            if (m instanceof Menu) {
                Menu subMenu = (Menu)m;
                this.parseMenu(path + " > " + label, subMenu);
                continue;
            }
            String trimmedLabel = label.trim();
            if (trimmedLabel.length() == 0 || trimmedLabel.equals("-")) continue;
            CommandAction ca = (CommandAction)this.commandsHash.get(label);
            if (ca == null) {
                this.commandsHash.put(label, new CommandAction(null, m, path));
            } else {
                ca.menuItem = m;
                ca.menuLocation = path;
            }
            CommandAction caAfter = (CommandAction)this.commandsHash.get(label);
        }
    }

    public void findAllMenuItems() {
        MenuBar menuBar = Menus.getMenuBar();
        int topLevelMenus = menuBar.getMenuCount();
        for (int i = 0; i < topLevelMenus; ++i) {
            Menu topLevelMenu = menuBar.getMenu(i);
            this.parseMenu(topLevelMenu.getLabel(), topLevelMenu);
        }
    }

    public void run(String ignored) {
        this.commandsHash = new Hashtable();
        Hashtable realCommandsHash = Menus.getCommands();
        Set realCommandSet = realCommandsHash.keySet();
        Iterator i = realCommandSet.iterator();
        while (i.hasNext()) {
            String command = (String)i.next();
            String trimmedCommand = command.trim();
            if (trimmedCommand.length() <= 0 || trimmedCommand.equals("-")) continue;
            this.commandsHash.put(command, new CommandAction((String)realCommandsHash.get(command), null, null));
        }
        this.findAllMenuItems();
        this.commands = this.commandsHash.keySet().toArray(new String[0]);
        Arrays.sort(this.commands);
        this.listLabelToCommand = new Hashtable();
        for (int i2 = 0; i2 < this.commands.length; ++i2) {
            CommandAction ca = (CommandAction)this.commandsHash.get(this.commands[i2]);
            this.listLabelToCommand.put(this.makeListLabel(this.commands[i2], ca, true), this.commands[i2]);
            this.listLabelToCommand.put(this.makeListLabel(this.commands[i2], ca, false), this.commands[i2]);
        }
        ImageJ imageJ = IJ.getInstance();
        this.d = new Dialog((Frame)imageJ, "Command Finder");
        this.d.setLayout(new BorderLayout());
        this.d.addWindowListener(this);
        this.fullInfoCheckbox = new Checkbox("Show full information", false);
        this.fullInfoCheckbox.addItemListener(this);
        this.closeCheckbox = new Checkbox("Close when running", true);
        this.closeCheckbox.addItemListener(this);
        Panel northPanel = new Panel();
        northPanel.add(new Label("Type part of a command:"));
        this.prompt = new TextField("", 30);
        this.prompt.addTextListener(this);
        this.prompt.addKeyListener(this);
        northPanel.add(this.prompt);
        this.d.add((Component)northPanel, "North");
        this.completions = new List(20);
        this.completions.addKeyListener(this);
        this.populateList("");
        this.d.add((Component)this.completions, "Center");
        this.runButton = new Button("Run");
        this.closeButton = new Button("Close");
        this.runButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.runButton.addKeyListener(this);
        this.closeButton.addKeyListener(this);
        Panel southPanel = new Panel();
        southPanel.setLayout(new BorderLayout());
        Panel optionsPanel = new Panel();
        optionsPanel.add(this.fullInfoCheckbox);
        optionsPanel.add(this.closeCheckbox);
        Panel buttonsPanel = new Panel();
        buttonsPanel.add(this.runButton);
        buttonsPanel.add(this.closeButton);
        southPanel.add((Component)optionsPanel, "Center");
        southPanel.add((Component)buttonsPanel, "South");
        this.d.add((Component)southPanel, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.d.pack();
        int dialogWidth = this.d.getWidth();
        int dialogHeight = this.d.getHeight();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        Point pos = imageJ.getLocationOnScreen();
        int initialX = (int)pos.getX() + 38;
        int initialY = (int)pos.getY() + 84;
        if (initialX + dialogWidth > screenWidth) {
            initialX = screenWidth - dialogWidth;
        }
        if (initialX < 0) {
            initialX = 0;
        }
        if (initialY + dialogHeight > screenHeight) {
            initialY = screenHeight - dialogHeight;
        }
        if (initialY < 0) {
            initialY = 0;
        }
        this.d.setLocation(initialX, initialY);
        this.d.setVisible(true);
    }

    public void windowClosing(WindowEvent e) {
        this.d.dispose();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    class CommandAction {
        String classCommand;
        MenuItem menuItem;
        String menuLocation;

        CommandAction(String classCommand, MenuItem menuItem, String menuLocation) {
            this.classCommand = classCommand;
            this.menuItem = menuItem;
            this.menuLocation = menuLocation;
        }

        public String toString() {
            return "classCommand: " + this.classCommand + ", menuItem: " + this.menuItem + ", menuLocation: " + this.menuLocation;
        }
    }
}

